<?php get_header(); ?>

<div class="category-container">
    <!-- Category Title -->
    <h1 class="category-title"><?php single_cat_title(); ?></h1>

    <!-- Posts Grid: 2 posts per row on larger screens and 1 on mobile -->
    <div class="posts-container">
        <?php if (have_posts()) : while (have_posts()) : the_post(); 
		$thumbnail_url = get_the_post_thumbnail_url(get_the_ID(), 'full');


		?>
            <div class="post-box">
                <div class="post-inner">
                    <!-- Left side: Featured Image with link -->
                       <!-- Gallery Wrapper -->
            <div id="lightGallery-<?php the_ID(); ?>" class="gallery-wrapper">
                <!-- Featured Image as trigger -->
                <a href="<?php echo esc_url($thumbnail_url);?>" data-src="<?php echo esc_url($thumbnail_url);?>" class="post-image-link">
                    <div class="post-image">
                        <?php if (has_post_thumbnail()) {
                            the_post_thumbnail('medium');
                        } ?>
                    </div>
                </a>
                <!-- Gallery Images -->
                <?php
                $images = acf_photo_gallery('images', $post->ID);
                if ($images) :
                    foreach ($images as $image) :
				$full_image_url= $image['full_image_url']; 
                $thumbnail_image_url= $image['thumbnail_image_url']; 
                ?>
                    <a  href="<?php echo $full_image_url; ?>" data-src="<?php echo $full_image_url; ?>">
                        <img style="width:1px;" src="<?php echo $thumbnail_image_url; ?>" />
                    </a>
                <?php
                    endforeach;
                endif;
                ?>
            </div>

                    <!-- Right side: Post Content -->
                    <div class="post-content">
                        
                            <p class="post-category"><?php the_category(', '); ?></p>
                       
                            <h2 class="post-title"><?php the_title(); ?></h2>

                        <!-- Excerpt -->
                        <div class="post-excerpt excerpt-collapsed">
                            <?php the_excerpt(); ?>
                        </div>

                       <div class="post-content2">
                            <?php the_content(); ?>
                        </div>

                        <!-- Arrow for collapsing/expanding content -->
                        <div class="arrow-toggle">˅</div>
                    </div>
                </div>
            </div>
        <?php endwhile; endif; ?>
    </div>
</div>

<?php get_footer(); ?>





<style>

.category-container {
    margin-top: 3em;
}

p {
    margin-bottom: 0em;
}

/* Category Title */
.category-title {
    color: var(--e-global-color-primary);
    font-family: "Martel", Sans-serif;
    font-size: 40px;
    font-weight: 900;
    text-transform: uppercase;
    margin-bottom: 40px;
    text-align: left;
}


.post-box {
    background: #fff;
    border: 2px solid #ba1e00;
    border-radius: 20px;
    padding: 30px 15px;
    position: relative;
    width: 48%;
    float: left;
    margin-right: 24px;
	margin-bottom: 25px;
	min-height:284px;
}
.posts-container {
    margin-bottom: 60px;
    float: left;
    width: 100%;
}
/* Post Layout */
.post-inner {
    display: flex;
    align-items: center; /* Vertically center align the content */
    width: 100%;
}

.post-image-link {
    flex-shrink: 0;
    margin-right: 20px;
    display: block;
}

.post-image img {
    max-width: 205px;
    border-radius: 10px;
    height: auto;
}
.post-content2 {
    font-size: 20px;
    font-weight: 700;
}
.post-content {
    flex-grow: 1;
}
.post-content2 a {
    float: left;
    color: #BA1E00;
}
.post-category-link {
    text-decoration: none;
}

.post-category {
    font-size: 14px;
}

.post-category a {
    color: #BA1E00;
    font-family: "Assistant", Sans-serif;
    font-size: 30px;
    font-weight: 700;
    text-transform: uppercase;
}

.post-title-link {
    text-decoration: none;
}

.post-title {
    margin-bottom: 10px;
    transition: color 0.3s;
    font-family: "Martel", Sans-serif;
    font-size: 32px;
    font-weight: 600;
    text-transform: uppercase;
}

.post-title:hover {
    color: #ba1e00;
}

/* Excerpt is initially collapsed to show only 2 lines */
.post-excerpt {
    overflow: hidden;
    max-height: 3em; /* Show only 2 lines */
    transition: max-height 0.5s ease;
	font-weight:700;
}

.excerpt-expanded {
    max-height: 100em; /* Expand to show full content */
}

/* Toggle Arrow */
.arrow-toggle {
    font-size: 38px;
    cursor: pointer;
    position: absolute;
    user-select: none;
    top: 0px !important;
    right: 0px !important;
    color: #fff !important;
    background-color: #BA1E00;
    padding: 0 20px;
    border-radius: 0px 18px 0 20px;
}

/* Arrow Rotation when content is expanded */
.arrow-toggle.expanded {
    transform: rotate(180deg);
}
.post-content2 {
    display: none;
}

.arrow-toggle {
    cursor: pointer;
}
@media (min-width: 922px) {
    .site-content .ast-container {
        display: block;
    }
}

/* Mobile Devices: 1 post per row */
@media (max-width: 767px) {
    .post-box {
        flex-basis: 100%; /* 1 post per row on mobile */
    }

    .post-inner {
        flex-direction: column;
        align-items: flex-start;
    }

    .post-image {
        margin-bottom: 15px;
    }
	.post-box { width:100%; margin-right:0px;}
	.post-image img {
    max-width: 100%;
}
}

</style>


<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
    jQuery(document).ready(function($) {
        $('.arrow-toggle').on('click', function() {
            var postInner = $(this).closest('.post-inner');
            postInner.find('.post-content2').toggle();
            postInner.find('.post-excerpt').toggle();
            $(this).text($(this).text() === '˄' ? '˅' : '˄');
        });
    });
</script>



<!-- CSS -->
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/lightgallery@2.3.0/css/lightgallery.min.css">

<!-- JavaScript -->
<script src="https://cdn.jsdelivr.net/npm/lightgallery@2.3.0/lightgallery.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/lg-thumbnail@2.3.0/lg-thumbnail.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/lg-zoom@2.3.0/lg-zoom.min.js"></script>

<script>
    document.addEventListener('DOMContentLoaded', function() {
        document.querySelectorAll('.post-image-link').forEach(function(link) {
            link.addEventListener('click', function(event) {
                event.preventDefault();
                var galleryWrapper = event.target.closest('.post-inner').querySelector('.gallery-wrapper');

                if (galleryWrapper) {
                    lightGallery(galleryWrapper, {
                        // Ensure these settings match your intended gallery behavior
                        thumbnail: true,
                        zoom: true,
                        selector: 'a' // Ensure all anchor tags are targeted
                    });
                } else {
                    console.error('Gallery wrapper not found');
                }
            });
        });
    });
</script>

